"""Definition of the Book content type
"""

from zope.interface import implements

from Products.Archetypes import atapi
from Products.ATContentTypes.content import base
from Products.ATContentTypes.content import schemata

from tutorial.i18n import i18nMessageFactory as _
from tutorial.i18n.interfaces import IBook
from tutorial.i18n.config import PROJECTNAME


AUDIENCES = atapi.DisplayList((
    ('children', _(u'Children')),
    ('adults',   _(u'Adults')),
    ('geeks',    _(u'Geeks')),
))


BookSchema = schemata.ATContentTypeSchema.copy() + atapi.Schema((

    atapi.StringField(
        name='author',
        required=False,
        schemata ='default',
        widget=atapi.StringWidget(
            label=_(u"Author"),
            description=_(u"Name of Author"),
        ),
    ),

    atapi.StringField(
        name='audience',
        required=False,
        schemata ='default',
        default='adults',
        vocabulary=AUDIENCES,
        languageIndependent = True,
        widget=atapi.SelectionWidget(
            label=_(u"Audience"),
            description=_(u"For what audience is this book written?"),
        ),
    ),

    atapi.DateTimeField(
        name='date',
        accessor='Date',
        schemata = 'default',
        languageIndependent = True,
        widget=atapi.CalendarWidget(
            label=_(u"label_publication_date", default=u"Publication date"),
            description=_(u"The date the book was published."),
        ),
    ),

))

schemata.finalizeATCTSchema(BookSchema)


class Book(base.ATCTContent):
    """A simple book type"""
    implements(IBook)

    schema = BookSchema


atapi.registerType(Book, PROJECTNAME)
