from zope.i18n import translate
from zope.interface import implements, Interface

from Acquisition import aq_inner
from Products.Five import BrowserView
from Products.CMFCore.utils import getToolByName


class IBookListing(Interface):
    """ A listing of books. """

    def books(self):
        """ Returns a list of books. """


class BookListing(BrowserView):
    """ A listing of books. """

    implements(IBookListing)

    def portal_url(self):
        context = aq_inner(self.context)
        portal = getToolByName(context, 'portal_url').getPortalObject()
        return portal.absolute_url()

    def books(self):
        """ Returns a list of books. """
        context = aq_inner(self.context)
        catalog = getToolByName(context, 'portal_catalog')

        query = {
            'portal_type' : 'Book',
        }

        results = list()
        for brain in catalog(**query):
            obj = brain.getObject()

            # Archetypes vocabulary API, mmmh
            audience = obj.getAudience()
            field = obj.getField('audience', obj)
            vocab = field.Vocabulary(obj)
            audience = vocab.getValue(audience)

            # Translate the audience field
            audience = translate(audience, context=self.request)

            results.append({
                'url' : brain.getPath(),
                'title' : obj.Title(),
                'description' : obj.Description(),
                'date' : obj.Date(),
                'audience' : audience,
            })

        # Sort the result list based on the audience
        def sort_key(item):
            return item.get('audience')

        results.sort(key=sort_key)

        return results
