from zope.i18nmessageid import MessageFactory

from AccessControl import ModuleSecurityInfo
from Products.CMFCore import utils

from tutorial.i18n import config

# We want to support multi-lingual content
try:
    from Products.LinguaPlone.public import listTypes
    from Products.LinguaPlone.public import process_types
except ImportError:
    from Products.Archetypes.atapi import listTypes
    from Products.Archetypes.atapi import process_types

# Define a message factory for when this product is internationalised.
# This will be imported with the special name "_" in most modules. Strings
# like _(u"message") will then be extracted by i18n tools for translation.

i18nMessageFactory = MessageFactory('tutorial.i18n')

# If we want to be able to use the message factory in restriced code, like
# Python scripts, we need to allow its usage.

ModuleSecurityInfo('tutorial.i18n').declarePublic('i18nMessageFactory')


def initialize(context):
    """Initializer called when used as a Zope 2 product.
    """

    content_types, constructors, ftis = process_types(
        listTypes(config.PROJECTNAME),
        config.PROJECTNAME)

    for atype, constructor in zip(content_types, constructors):
        utils.ContentInit('%s: %s' % (config.PROJECTNAME, atype.portal_type),
            content_types      = (atype,),
            permission         = config.ADD_PERMISSIONS[atype.portal_type],
            extra_constructors = (constructor,),
            ).initialize(context)
